<?php $__env->startSection('content'); ?>
    <div class="mainSection-title">
        <div class="row">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center flex-wrap gr-15">
                    <div class="d-flex flex-column">
                        <h4><?php echo e(get_phrase('Hostels')); ?></h4>
                        <ul class="d-flex align-items-center eBreadcrumb-2">
                            <li><a href="#"><?php echo e(get_phrase('Home')); ?></a></li>
                            <li><a href="#"><?php echo e(get_phrase('Hostels')); ?></a></li>
                        </ul>
                    </div>
                    <div class="export-btn-area">
                        <a href="javascript:;" class="export_btn" onclick="rightModal('<?php echo e(route('admin.hostel.create_hostel')); ?>', '<?php echo e(get_phrase('Create Hostel')); ?>')"><?php echo e(get_phrase('Add Hostel')); ?></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-7 offset-md-2">
            <div class="eSection-wrap">
                <?php if(count($hostels) > 0): ?>
                    <!-- Table -->
                    <div class="table-responsive tScrollFix pb-2">
                        <table class="table eTable">
                            <thead>
                                <tr>
                                    <th scope="col">#</th>
                                    <th scope="col"><?php echo e(get_phrase('Hostel Name')); ?></th>
                                    <th scope="col"><?php echo e(get_phrase('Hostel Type')); ?></th>
                                    <th scope="col"><?php echo e(get_phrase('Hostel Address')); ?></th>
                                    <th scope="col" class="text-end"><?php echo e(get_phrase('Options')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $hostels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $hostel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>
                                            <?php echo e($key + 1); ?>

                                        </td>
                                        <td>
                                            <?php echo e($hostel['name']); ?>

                                        </td>
                                        <td>
                                            <?php echo e($hostel['type'] == 1 ? 'Boys' : 'Girls'); ?>

                                        </td>
                                        <td>
                                            <?php echo e($hostel['address']); ?>

                                        </td>
                                        <td class="text-center">
                                            <div class="adminTable-action">
                                                <button type="button" class="eBtn eBtn-black dropdown-toggle table-action-btn-2" data-bs-toggle="dropdown" aria-expanded="false">
                                                    <?php echo e(get_phrase('Actions')); ?>

                                                </button>
                                                <ul class="dropdown-menu dropdown-menu-end eDropdown-menu-2 eDropdown-table-action">
                                                    <li>
                                                        <a class="dropdown-item" href="javascript:;" onclick="rightModal('<?php echo e(route('admin.hostel.edit_hostel', ['id' => $hostel->id])); ?>', '<?php echo e(get_phrase('Edit Hostel')); ?>')"><?php echo e(get_phrase('Edit')); ?></a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item" href="javascript:;" onclick="confirmModal('<?php echo e(route('admin.hostel.delete_hostel', ['id' => $hostel->id])); ?>', 'undefined');"><?php echo e(get_phrase('Delete')); ?></a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <div class="hostels_content">
                        <div class="empty_box center">
                            <img class="mb-3" width="150px" src="<?php echo e(asset('assets/images/empty_box.png')); ?>" />
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <!-- End Exam category area -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.navigation', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\MAMP\htdocs\ekattor8\resources\views/admin/hostel/list.blade.php ENDPATH**/ ?>