<?php $__env->startSection('content'); ?>
    <div class="mainSection-title">
        <h4><?php echo e(get_phrase('Pending Offline Payments')); ?></h4>
        <ul class="d-flex align-items-center eBreadcrumb-2">
            <li><a href="#"><?php echo e(get_phrase('Home')); ?></a></li>
            <li><a href="#"><?php echo e(get_phrase('Hostel')); ?></a></li>
            <li><a href="#"><?php echo e(get_phrase('Offline Payments')); ?></a></li>
        </ul>
    </div>

    <div class="eSection-wrap">
        <div class="table-responsive">
            <table class="table eTable">
                <thead>
                    <tr>
                        <th><?php echo e(get_phrase('Student')); ?></th>
                        <th><?php echo e(get_phrase('Month')); ?></th>
                        <th><?php echo e(get_phrase('Amount')); ?></th>
                        <th><?php echo e(get_phrase('Status')); ?></th>
                        <th><?php echo e(get_phrase('Payment Document')); ?></th>
                        <th><?php echo e(get_phrase('Action')); ?></th>
                    </tr>
                </thead>

                <tbody>
                    <?php $__currentLoopData = $pendingPayments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $student = \App\Models\User::find($fee->student_id);
                        ?>
                        <tr>
                            <td>
                                <?php echo e($student->name ?? 'N/A'); ?><br>
                                <small><?php echo e($student->email ?? ''); ?></small>
                            </td>

                            <td><?php echo e(Carbon\Carbon::parse($fee->fee_payment_date)->format('M Y')); ?></td>

                            <td><?php echo e($fee->amount ?? '-'); ?></td>

                            <td>
                                <span class="eBadge ebg-soft-warning">
                                    <?php echo e(get_phrase('Pending')); ?>

                                </span>
                            </td>
                            <td class="link">
                                <?php if(!empty($fee->document_image)): ?>
                                    <?php
                                        $fileExtension = pathinfo($fee->document_image, PATHINFO_EXTENSION);
                                        $allowedExtensions = ['jpg', 'jpeg', 'png', 'gif', 'webp'];

                                    ?>

                                    <?php if(in_array(strtolower($fileExtension), $allowedExtensions)): ?>
                                        <a href="<?php echo e(asset('assets/uploads/hostel_fees/' . $fee->document_image)); ?>" download data-lightbox="models" data-title="<?php echo e($fee->document_image); ?>"> <strong><?php echo e($fee->document_image); ?> </strong>
                                        <?php else: ?>
                                            <a href="<?php echo e(asset('assets/uploads/hostel_fees/' . $fee->document_image)); ?>" download data-title="<?php echo e($fee->document_image); ?>"> <strong><?php echo e($fee->document_image); ?> </strong>
                                    <?php endif; ?>
                                <?php endif; ?>

                                </a>
                            </td>
                            <td class="text-start">
                                <div class="adminTable-action">
                                    <button type="button" class="eBtn eBtn-black dropdown-toggle table-action-btn-2" data-bs-toggle="dropdown" aria-expanded="false">
                                        <?php echo e(get_phrase('Actions')); ?>

                                    </button>

                                    <ul class="dropdown-menu dropdown-menu-end eDropdown-menu-2 eDropdown-table-action">

                                        <li>
                                            <a class="dropdown-item" href="javascript:;" onclick="confirmModal('<?php echo e(route('admin.accept.offline.payment.hostel', $fee->id)); ?>', 'undefined');">
                                                <?php echo e(get_phrase('Accept')); ?>

                                            </a>
                                        </li>

                                        <li>
                                            <a class="dropdown-item" href="javascript:;" onclick="confirmModal('<?php echo e(route('admin.reject.offline.payment.hostel', $fee->id)); ?>', 'undefined');">
                                                <?php echo e(get_phrase('Reject')); ?>

                                            </a>
                                        </li>



                                    </ul>
                                </div>
                            </td>

                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>

        <div class="d-flex justify-content-center mt-3">
            <?php echo e($pendingPayments->links()); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.navigation', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\MAMP\htdocs\ekattor8\resources\views/admin/hostel_fee_manager/offline_payments.blade.php ENDPATH**/ ?>