<form method="POST" class="d-block ajaxForm" action="<?php echo e(route('admin.club.update', $club->id)); ?>">
    <?php echo csrf_field(); ?>
    <?php echo method_field('POST'); ?>

    <div class="form-row">

        <div class="fpb-7">
            <label for="club_name" class="eForm-label"><?php echo e(get_phrase('Club Name')); ?></label>
            <input type="text" class="form-control eForm-control" id="club_name" name="club_name"
                value="<?php echo e(old('club_name', $club->club_name)); ?>" required>
        </div>

        <div class="fpb-7">
            <label for="advisor_id" class="eForm-label"><?php echo e(get_phrase('Advisor (Teacher)')); ?></label>
            <select name="advisor_id" id="advisor_id" class="form-select eForm-control" required>
                <option value=""><?php echo e(get_phrase('Select Teacher')); ?></option>
                <?php $__currentLoopData = $teachers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $teacher): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($teacher->id); ?>" <?php echo e($club->advisor_id == $teacher->id ? 'selected' : ''); ?>>
                        <?php echo e($teacher->name); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        <div class="fpb-7">
            <label for="status" class="eForm-label"><?php echo e(get_phrase('Status')); ?></label>
            <select name="status" id="status" class="form-select eForm-control">
                <option value="1" <?php echo e($club->status == 1 ? 'selected' : ''); ?>><?php echo e(get_phrase('Active')); ?></option>
                <option value="0" <?php echo e($club->status == 0 ? 'selected' : ''); ?>><?php echo e(get_phrase('Inactive')); ?></option>
            </select>
        </div>

        <div class="fpb-7">
            <label for="description" class="eForm-label"><?php echo e(get_phrase('Description')); ?></label>
            <textarea name="description" id="description" class="form-control eForm-control" rows="4"><?php echo e(old('description', $club->description)); ?></textarea>
        </div>

        <div class="fpb-7 pt-2">
            <button class="btn-form" type="submit"><?php echo e(get_phrase('Save Club')); ?></button>
        </div>

    </div>
</form>
<script type="text/javascript">

    "use strict";

    $(document).ready(function () {
      $(".eChoice-multiple-with-remove").select2();
    });

    $(function () {
      $('.inputDate').daterangepicker(
        {
          singleDatePicker: true,
          showDropdowns: true,
          minYear: 1901,
          maxYear: parseInt(moment().format("YYYY"), 10),
        },
        function (start, end, label) {
          var years = moment().diff(start, "years");
        }
      );
    });

    $(document).ready(function () {
      $(".eChoice-multiple-with-remove").select2();
    });

</script><?php /**PATH D:\MAMP\htdocs\ekattor8\resources\views/admin/club/edit_club.blade.php ENDPATH**/ ?>